/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CCRSVerisignServer.cpp,v 1.4 2000/07/10 22:04:59 dallen Exp $
____________________________________________________________________________*/

#include <string.h>

#include "pgpMem.h"
#include "pgpUtilities.h"
#include "pgpKeys.h"

#include "StPGPRefs.h"
#include "CCRSVerisignServer.h"


// namespace {
		static const char *	kContentType	=	"application/octet-stream";
		static const char *	kDefaultPath	=	"/crs.exe";
// }


CCRSVerisignServer::CCRSVerisignServer(
	PGPContextRef			inContext,
	const char *			inHostName,
	PGPUInt32				inHostAddress,
	PGPUInt16				inHostPort,
	const char *			inPath,
	PGPKeyServerProtocol	inProtocol,
	PGPKeyServerClass		inClass)
		: CCRSServer(inContext, inHostName, inHostAddress, inHostPort, inPath, inProtocol, inClass)
{
}



CCRSVerisignServer::~CCRSVerisignServer()
{
}



	void
CCRSVerisignServer::SendCertificateRequest(
	PGPKeyDBObjRef	inCAKey,
	PGPKeyDBObjRef	inRequestKey,
	const void *	inBuffer,
	PGPSize			inBufferSize,
	void **			outBuffer,
	PGPSize *		outBufferSize)
{
	(void) inRequestKey;
	(void) inCAKey;
	
	try {
		InitOperation();
		if (IsNull(inBuffer)) {
			ThrowPGPError_(kPGPError_OptionNotFound);
		}

		*outBufferSize = PostCRSMessage(kPGPKeyServerState_Uploading,
										(mPath == 0) ? kDefaultPath : mPath,
										reinterpret_cast<PGPByte **>(outBuffer),
										inBufferSize,
										static_cast<const PGPByte *>(inBuffer));
	}
	
	catch (...) {
		if (mCanceled) {
			ThrowPGPError_(kPGPError_UserAbort);
		} else {
			throw;
		}
	}
}



	void
CCRSVerisignServer::RetrieveCertificate(
	PGPFilterRef	inSearchFilter,
	PGPKeyDBObjRef	inSearchKey,
	PGPKeyDBObjRef	inCAKey,
	PGPKeyDBObjRef	inSigningKey,
	PGPByte *		inPassphrase,
	PGPSize			inPassphraseLength,
	PGPBoolean		inIsPassphrase,
	void **			outBuffer,
	PGPSize *		outBufferSize)
{
	(void) inSearchFilter;
	(void) inCAKey;

	try {
		PackageAndSendCRSMessage(	kPGPExportFormat_VerisignV1_GetCertInitial,
									kPGPOutputFormat_VerisignV1_GetCertInitialInPKCS7,
									inSearchKey,
									inSigningKey,
									inPassphrase,
									inPassphraseLength,
									inIsPassphrase,
									outBuffer,
									outBufferSize);
	}
	
	catch (...) {
		if (mCanceled) {
			ThrowPGPError_(kPGPError_UserAbort);
		} else {
			throw;
		}
	}
}



	void
CCRSVerisignServer::RetrieveCRL(
	PGPKeyDBObjRef	inCAKey,
	PGPKeyDBObjRef	inSigningKey,
	PGPByte *		inPassphrase,
	PGPSize			inPassphraseLength,
	PGPBoolean		inIsPassphrase,
	void **			outBuffer,
	PGPSize *		outBufferSize)
{
	try {
		PackageAndSendCRSMessage(	kPGPExportFormat_VerisignV1_GetCRL,
									kPGPOutputFormat_VerisignV1_GetCRLInPKCS7,
									inCAKey,
									inSigningKey,
									inPassphrase,
									inPassphraseLength,
									inIsPassphrase,
									outBuffer,
									outBufferSize);
	}
	
	catch (...) {
		if (mCanceled) {
			ThrowPGPError_(kPGPError_UserAbort);
		} else {
			throw;
		}
	}
}



	PGPUInt32
CCRSVerisignServer::PostCRSMessage(
	PGPKeyServerState	inOperation,
	const char *		inPath,
	PGPByte**			outResult,
	PGPUInt32			inContentLength,
	const PGPByte *		inData)
{
	StPGPDataRef	result;
	PGPSize			resultSize;

	resultSize = GetPost(inOperation, inPath, &result, kContentType, inContentLength, inData);
	CheckAndRemoveHTTPHeader(result, resultSize, outResult, &resultSize);

	return resultSize;
}



	void
CCRSVerisignServer::PackageAndSendCRSMessage(
	PGPExportFormat	inExportFormat,
	PGPOutputFormat	inOutputFormat,
	PGPKeyDBObjRef	inKey,
	PGPKeyDBObjRef	inSigningKey,
	PGPByte *		inPassphrase,
	PGPSize			inPassphraseLength,
	PGPBoolean		inIsPassphrase,
	void **			outBuffer,
	PGPSize *		outBufferSize)
{
	PGPError		pgpErr;
	StPGPDataRef	buffer;
	PGPSize			bufSize;
	StPGPDataRef	crsMessage;
	PGPSize			crsMessageSize;
	
	InitOperation();
	if (! PGPKeyDBObjRefIsValid(inKey)) {
		ThrowPGPError_(kPGPError_OptionNotFound);
	}
	if (! PGPKeyDBObjRefIsValid(inSigningKey)) {
		ThrowPGPError_(kPGPError_OptionNotFound);
	}
	if (IsNull(inPassphrase)) {
		ThrowPGPError_(kPGPError_OptionNotFound);
	}
	
	pgpErr = PGPExport(	mContext,
						PGPOExportKeyDBObj( mContext, inKey ),
						PGPOExportFormat(	mContext,
											inExportFormat),
						PGPOAllocatedOutputBuffer(	mContext,
													(void **) &buffer,
													MAX_PGPSize,
													&bufSize),
						PGPOLastOption(mContext));
	ThrowIfPGPError_(pgpErr);
	pgpErr = PGPEncode(	mContext,
						PGPOSignWithKey(	mContext,
											inSigningKey,
											(inIsPassphrase) ?
												PGPOPassphraseBuffer(mContext,
													inPassphrase, inPassphraseLength) :
												PGPOPasskeyBuffer(mContext,
													inPassphrase, inPassphraseLength),
											PGPOLastOption(mContext)),
						PGPOInputBuffer(mContext, static_cast<PGPByte *>(buffer), bufSize),
						PGPOAllocatedOutputBuffer(	mContext,
													(void **) &crsMessage,
													MAX_PGPSize,
													&crsMessageSize),
						PGPOOutputFormat(	mContext,
											inOutputFormat),
						PGPOLastOption(mContext));
	ThrowIfPGPError_(pgpErr);
	buffer.Free();
	*outBufferSize = PostCRSMessage(kPGPKeyServerState_Querying,
									(mPath == 0) ? kDefaultPath : mPath,
									reinterpret_cast<PGPByte **>(outBuffer),
									crsMessageSize,
									static_cast<const PGPByte *>(crsMessage));
}
